//var font = LoadFont("Final Fantasy VI - Text Font.rfn");
//var messageFont = LoadFont("Final Fantasy VI - Text Font.rfn");
//var font2 = LoadFont("Final Fantasy VI - Menu Font.rfn");

function fontObject(font)
{
  this.fontInner = LoadFont(font + " Inner.rfn");
  this.fontOutline = LoadFont(font + " Outline.rfn");
}

var font = new fontObject("Final Fantasy VI - Menu Font");
var messageFont = new fontObject("Final Fantasy VI - Text Font");



RequireScript("Colours.js");
RequireScript("Console.js");
RequireScript("Log System.js");
EvaluateScript("Final Fantasy VI - Clock.js");
EvaluateScript("Final Fantasy VI - Config.js");
EvaluateScript("Final Fantasy VI - Items.js");
EvaluateScript("Final Fantasy VI - Skills.js");
EvaluateScript("Final Fantasy VI - Espers.js");
EvaluateScript("Final Fantasy VI - Actors.js");
EvaluateScript("Final Fantasy VI - Menu System.js");
EvaluateScript("Final Fantasy VI - Message System.js");
RequireScript("Tile Movement.js");

// 64, 16, 256, 224

BindKey(KEY_ESCAPE, "", "");
BindKey(KEY_A, "", "menuCall()");
BindKey(KEY_S, "", "partyChanger()");

//function partyChanger()
//{
//  menus[27].done = false;
//  menus[27].execute();
//}

var steps = 0;
var gp = 0;

var updateFPS = 0;
var lastUpdateFPS = 0;
var lastRenderFPS = 0;
var renderFPS = 0;
var timeFPS = GetTime() + 1000;
var timeRFPS = GetTime() + 1000;
var teleportFunction = undefined;



function game()
{
  CreatePerson("Player", "Terra.rss", false);
  AttachCamera("Player");
  tileMovement.attachInput("Player");
  SetRenderScript("render()");
  SetUpdateScript("update()");
  MapEngine("Test Bed 3.rmp", 60);
}

function update()
{
  tileMovement.update();
  //console.update();
  if (GetTime() > timeFPS) 
  {
    timeFPS = GetTime() + 1000;
    lastUpdateFPS = updateFPS;
    updateFPS = 0;
  }
  updateFPS++;
  if (teleportFunction)
  {
    teleportFunction()
  }
}

function render()
{
  //var PX = MapToScreenX(0, GetPersonX("Player") - 119);
  //var PY = MapToScreenY(0, GetPersonY("Player") - 103);
  //if (PX < 0) PX = 0;
  //if (PX > 80) PX = 80;
  //if (PY < 0) PY = 0;
  //if (PY > 32) PY = 32;  
  //var newScreen = GrabImage(PX, PY, 240, 208);
  //Rectangle(0, 0, 320, 240, CreateColor(0, 255, 0, 255));
  //newScreen.blit(40,16);
  //console.render();
  tileMovement.renderInfo();
  for (var i = 0, len = renderscripts.length; i < len; i++) // FOR THE CONSOLE
  {
		renderscripts[i]();
	}
	font.fontInner.drawText(2, 17, "Update FPS rate = " + lastUpdateFPS);
	font.fontInner.drawText(2, 27, "Render FPS rate = " + lastRenderFPS);
	if (GetTime() > timeRFPS) 
  {
    timeRFPS = GetTime() + 1000;
    lastRenderFPS = renderFPS;
    renderFPS = 0;
  }
	renderFPS++;
}








function getWindow(x, y, w, h)
{
  // May need a height handler to hold it within 208
  if (y > 16)
  {
    this.y = y - 16
  }
  else
  {
    this.y = 0;
  }
  this.baseWindow = CreateSurface(w, h, CreateColor(0, 0, 0, 0));
  
  // Back Window
  this.backWindow = CreateSurface(w, h, CreateColor(0, 0, 0, 0));
  this.backWindow.transformBlitSurface(window7.cloneSection(0, this.y, 1, h), 0, 0, w, 0, w, h, 0, h);
  this.baseWindow.blitSurface(this.backWindow, 0, 0);
  // Back Window End
  
  // Top Window 
  this.baseWindow.blitSurface(topLeftBorder, 0, 0);
  this.baseWindow.blitSurface(topRightBorder, w - 6, 0);
  this.baseWindow.line(6, 0, w - 6, 0, red);
  this.baseWindow.line(6, 1, w - 6, 1, blue);
  this.baseWindow.line(6, 2, w - 6, 2, cyan);
  this.baseWindow.line(6, 3, w - 6, 3, yellow);
  this.baseWindow.replaceColor(red, window1.getPixel(0, this.y));
  this.baseWindow.replaceColor(green, window2.getPixel(0, this.y));
  this.baseWindow.replaceColor(blue, window3.getPixel(0, this.y));
  this.baseWindow.replaceColor(magenta, window4.getPixel(0, this.y));
  this.baseWindow.replaceColor(cyan, window5.getPixel(0, this.y));
  this.baseWindow.replaceColor(yellow, window6.getPixel(0, this.y));
  // Top Window End
  
  // Bottom Window
  this.baseWindow.blitSurface(bottomLeftBorder, 0, h - 6);
  this.baseWindow.blitSurface(bottomRightBorder, w - 6, h - 6);
  this.baseWindow.line(6, h - 4, w - 6, h - 4, yellow);
  this.baseWindow.line(6, h - 3, w - 6, h - 3, red);
  this.baseWindow.line(6, h - 2, w - 6, h - 2, blue);
  this.baseWindow.line(6, h - 1, w - 6, h - 1, cyan);
  this.baseWindow.replaceColor(red, window1.getPixel(0, this.y + h - 1));
  this.baseWindow.replaceColor(green, window2.getPixel(0, this.y + h - 1));
  this.baseWindow.replaceColor(blue, window3.getPixel(0, this.y + h - 1));
  this.baseWindow.replaceColor(magenta, window4.getPixel(0, this.y + h - 1));
  this.baseWindow.replaceColor(cyan, window5.getPixel(0, this.y + h - 1));
  this.baseWindow.replaceColor(yellow, window6.getPixel(0, this.y + h - 1));
  // Bottom Window End
  
  // Window Sides
  this.baseWindow.blitSurface(window1.cloneSection(0, this.y + 5, 1, h - 12), 0, 6);
  this.baseWindow.blitSurface(window3.cloneSection(0, this.y + 5, 1, h - 12), 1, 6);
  this.baseWindow.blitSurface(window5.cloneSection(0, this.y + 5, 1, h - 12), 2, 6);
  this.baseWindow.blitSurface(window6.cloneSection(0, this.y + 5, 1, h - 12), 3, 6);
  
  this.baseWindow.blitSurface(window5.cloneSection(0, this.y + 5, 1, h - 12), w - 1, 6);
  this.baseWindow.blitSurface(window3.cloneSection(0, this.y + 5, 1, h - 12), w - 2, 6);
  this.baseWindow.blitSurface(window1.cloneSection(0, this.y + 5, 1, h - 12), w - 3, 6);
  this.baseWindow.blitSurface(window6.cloneSection(0, this.y + 5, 1, h - 12), w - 4, 6);
   // Window Sides End
   
  return this.baseWindow.createImage();
}

function drawWindow(menu, x, y, w, h)
{
  if (!menu.window)
  {
    menu.window = getWindow(x, y, w, h);
  }
  menu.window.blit(x, y)
}

function teleport(map)
{
  var attached = tileMovement.player;
  tileMovement.detachInput();
  ChangeMap(map);
  tileMovement = new tileMove();
  tileMovement.attachInput(attached)
  clearKeyQueue()
}

function clearKeyQueue()
{
  while (AreKeysLeft())
  {
    GetKey();
  }
}

function menuCall()
{
  menus[0].done = false;
  menus[0].openMenu();
  //menus[0].initialize();
}

var whole = LoadImage("Test.png").createSurface();
var TL = whole.cloneSection(0, 0, 8, 8);
var TR = whole.cloneSection(16, 0, 8, 8);
var BL = whole.cloneSection(0, 16, 8, 8);
var BR = whole.cloneSection(16, 16, 8, 8);
var T = whole.cloneSection(8, 0, 8, 8);
var L = whole.cloneSection(0, 8, 8, 8);
var B = whole.cloneSection(8, 16, 8, 8);
var R = whole.cloneSection(16, 8, 8, 8);
var BACK = whole.cloneSection(8, 8, 8, 8);

var windowSkin = LoadWindowStyle("FF6.rws");
var gradient = LoadImage("Gradient.png").createSurface();

//function drawWindow(x, y, w, h)
//{
//  var temp = CreateSurface(w, h, CreateColor(0, 0, 0, 0));
//  temp.blitSurface(gradient.cloneSection(0, y, w, h), 0, 0);
//  temp.blit(x, y);
//}

function drawWindow2(x, y, w, h)
{
  var base = CreateSurface(w, h, CreateColor(0, 0, 0, 0));

  base.transformBlitSurface(BACK, 8, 8, w - 9, 8, w - 9, h - 9, 8, h - 9);
  base.transformBlitSurface(T, 8, 0, w - 9, 0, w - 9, 7, 0, 7);
  base.blitSurface(TL, 0, 0);
  base.transformBlitSurface(L, 0, 8, 7, 8, 7, h - 9, 0, h - 9); 
  base.blitSurface(TR, w - 8, 0);
  base.transformBlitSurface(R, w - 8, 8, w - 1, 8, w - 1, h - 9, w - 8, h - 9);
  base.blitSurface(BL, 0, h - 8);
  base.transformBlitSurface(B, 8, h - 8, w - 8, h - 8, w - 8, h - 1, 8, h - 1);
  base.blitSurface(BR, w - 8, h - 8);
  
  base.blit(x, y);
}